<div class="modal-dialog modal-sm">
  <div class="modal-content">
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
      {{ trans('wallet::lang.transfer_balance') }}
    </div>
    {!! Form::open(['route' => 'merchant.wallet.transfer', 'id' => 'form', 'data-toggle' => 'validator']) !!}
    <div class="modal-body">

      <div class="form-group space30">
        {!! Form::label('order', trans('wallet::lang.amount')) !!}
        <div class="input-group">
          @if (get_currency_prefix())
            <span class="input-group-addon">
        {{ get_currency_prefix() }}
      </span>
          @endif

          {!! Form::number('amount', null, ['class' => 'form-control', 'step' => 'any', 'placeholder' => trans('wallet::lang.amount'), 'max' => $wallet->balance, 'required']) !!}

          @if (get_currency_suffix())
            <span class="input-group-addon">
        {{ get_currency_suffix() }}
      </span>
          @endif
        </div>
        <div class="help-block with-errors">{{ trans('wallet::lang.max_tarnfer_amount', ['amount' => get_formated_currency($wallet->balance, 2)]) }}</div>
      </div>

    </div>
    <div class="modal-footer">
      {!! Form::submit(trans('wallet::lang.transfer'), ['class' => 'btn btn-flat btn-new']) !!}
    </div>
    {!! Form::close() !!}
  </div> <!-- / .modal-content -->
</div> <!-- / .modal-dialog -->
